/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.problem;

import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFactory;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;

public class PIMachineProblemFactory
implements ProblemFactory {
    private static final String TRACE_MASKT = "PPAMCPFT";
    private static final String TRACE_MASKF = "PPAMCPFF";
    private static final String TRACE_MASKD = "PPAMCPFD";
    public static final String DUMP_REFCODE = "B3031000";
    public static final String RC_SYS_CONSOLE_PROBLEM = "B3031000";
    public static final String RC_SYS_POWER = "B3031001";
    public static final String RC_SYS_CPC = "B3031002";
    public static final String RC_SYS_LAN = "B3031003";
    public static final String RC_SYS_SOFTWARE = "B3031004";
    public static final String RC_SYS_IO = "B3031005";
    public static final String RC_SYS_OTHER = "B3031006";

    public Problem createProblem(Object contextObject) throws HException {
        if (contextObject == null || contextObject instanceof PASystem) {
            PIProblem cp = new PIProblem();
            cp.setReportingRemoteMachineSystem((PASystem)contextObject);
            ConsoleAnalysisDomain cad = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
            cp.setPrimaryAnalyzingConsoleSystem(cad.getConsoleSystem());
            cp.setFailingSystem((PASystem)contextObject);
            return cp;
        }
        throw new HException("unsupported context object[" + contextObject + "]");
    }

    public Problem createProblem(Object contextObject, String type) throws HException {
        Problem problem = this.createProblem(contextObject);
        if (problem instanceof CommonProblem) {
            if (type.equals("DumpProblem")) {
                ((CommonProblem)problem).setRefcode("B3031000");
                ((CommonProblem)problem).setDumpPending(true);
            } else if (type.equals("PowerProblem")) {
                ((CommonProblem)problem).setRefcode(RC_SYS_POWER);
            } else if (type.equals("ConsoleProblem")) {
                ((CommonProblem)problem).setRefcode("B3031000");
            } else if (type.equals("PowerProblem")) {
                ((CommonProblem)problem).setRefcode(RC_SYS_POWER);
            } else if (type.equals("CpcProblem")) {
                ((CommonProblem)problem).setRefcode(RC_SYS_CPC);
            } else if (type.equals("LanProblem")) {
                ((CommonProblem)problem).setRefcode(RC_SYS_LAN);
            } else if (type.equals("SoftwareProblem")) {
                ((CommonProblem)problem).setRefcode(RC_SYS_SOFTWARE);
            } else if (type.equals("IOProblem")) {
                ((CommonProblem)problem).setRefcode(RC_SYS_IO);
            } else {
                ((CommonProblem)problem).setRefcode(RC_SYS_OTHER);
            }
        }
        return problem;
    }

    public boolean isTypeSupported(String type) {
        return true;
    }

    public String[] typesSupported() {
        String[] supports = new String[]{"ConsoleProblem", "PowerProblem", "CpcProblem", "LanProblem", "SoftwareProblem", "IOProblem", "OtherProblem", "DumpProblem"};
        return supports;
    }
}

